﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace Programming_CSharp
{
    // Prosta klasa klienta
    public class Customer
    {
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string EmailAddress { get; set; }
    }

    // Główny program
    public class Tester
    {
        static void Main()
        {
            List<Customer> customers = CreateCustomerList();

            // Listing 12-5. Generowanie elementów XML za pomocą LINQ
            var customerXml = new XDocument(new XElement("Customers",
                from customer in customers
                select new XElement("Customer",
                    new XAttribute("FirstName", customer.FirstName),
                    new XAttribute("LastName", customer.LastName),
                    new XElement("EmailAddress", customer.EmailAddress)
                    )));

            Console.WriteLine(customerXml.ToString());
            Console.Read();
        }

        // Tworzenie listy klientów z przykładowymi danymi
        private static List<Customer> CreateCustomerList()
        {
            List<Customer> customers = new List<Customer>
                {
                new Customer { FirstName = "Marian",
                               LastName = "Opania",
                               EmailAddress = "marian0@onet.pl"},
                new Customer { FirstName = "Kajetan",
                               LastName = "Hardy",
                               EmailAddress = "kajtek0@interia.pl"},
                new Customer { FirstName = "Dorota",
                               LastName = "Czapska",
                               EmailAddress = "dorota0@adresik.pl"},
                new Customer { FirstName = "Jadwiga",
                               LastName = "Gaterska",
                               EmailAddress = "jadzia@wp.pl"},
                new Customer { FirstName = "Lucyna",
                               LastName = "Harmata",
                               EmailAddress = "lucyna0@interia.pl"}
                };
            return customers;
        }
    }
}